/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.storage;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public abstract class GitFileRevision
extends FileRevision {
    private static final String DEV_NULL = "/dev/null";
    private final String path;

    protected GitFileRevision(String fileName) {
        this.path = fileName;
    }

    public String getName() {
        if (this.path.equals(DEV_NULL)) {
            return this.path;
        }
        int last = this.path.lastIndexOf(File.separator);
        return last >= 0 ? this.path.substring(last + 1) : this.path;
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) {
        return this;
    }

    public URI getURI() {
        try {
            return new URI(null, null, this.path, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof GitFileRevision) {
            GitFileRevision other = (GitFileRevision)((Object)obj);
            return other.path.equals(this.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

